/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *
 *  Ten kod zawiera dziaajce wersje przykadw z pyta 6.16, 6.18,
 *  6.19 i 6.20.
 *
 *  Prbuj odpowiedzie na pytanie: Jak napisa funkcj, ktrej
 *  argumentem moe by tablica wielowymiarowa o dowolnych rozmiarach,
 *  przydzielona statycznie lub dynamicznie? Jak si okazuje, jzyk
 *  C nie daje dobrej odpowiedzi na to pytanie. (Istnieje jednak pytanie
 *  pomocnicze, na ktre *istnieje* odpowied (i udzielam jej tutaj):
 *  Jak przydzieli dynamicznie (albo, bardziej cile, zasymulowa)
 *  tablic dynamiczn o dowolnych rozmiarach?)
 *
 *  Ten kod zawiera dwa rodzaje "testw obcieniowych".
 *
 *  Po pierwsze, jest dobrym testem zrozumienia dziaania tablic
 *  i wskanikw w C. Deklaruj tu sze rodzajw tablic 
 *  wielowymiarowych i trzy funkcje, ktre akceptuj rne rodzaje 
 *  tablic wielowymiarowych, ale nie s one zgodne kada z kad. 
 *  Zastanw si, dlaczego te, ktre s zgodne ze sob, dziaaj (i 
 *  dlaczego wywoywane s tak, a nie inaczej)? Dlaczego pozostae 
 *  wersje nie s ze sob zgodne?
 *
 *  Po drugie, kod ten jest dobrym testem niektrych czci Twojego 
 *  kompilatora C lub programu lint. Niektre przypisania i wywoania 
 *  (te opatrzone komentarzami "ostrzeenie" i "sprawdzenie, czy 
 *  kompilator ostrzee") s zdecydowanie i celowo niepoprawne i powinny 
 *  wywoa komunikat ostrzegawczy (albo o bdzie) w kadym porzdnym 
 *  kompilatorze lub programie lint. (Jeeli czegos nie przeoczyem, 
 *  jedyne powane komunikaty to 2 o zych przypisaniach wskanikw i 9 
 *  o niezgodnoci typw argumentw funkcji. Inne ostrzeenia mog 
 *  by skutkiem starego stylu definicji funkcji, niewykorzystanych 
 *  argumentw, staych w warunkach, instrukcji switch bez etykiet case, 
 *  funkcji signal albo innych problemw, zwizanych z plikami 
 *  nagwkowymi w Twoim systemie.
 *
 *  Moe by pouczajce porwnanie kodu funkcji f() i f2(), a 
 *  szczeglnie f() i f3().
 *
 *  Several of the function calls in this program (those marked
 *  "nie powinno dziaa", and particularly those to f3()) are almost
 *  certain to result in Segmentation Violations or Bus Errors.
 *  The code catches these signals and prints a message when they
 *  occur, and attempts to continue, but depending on where the
 *  processor leaves the PC after a trap, it can go into quite a
 *  loop.  Don't run this code in an environment where you won't
 *  be able to abort it right away with control-C or the like.
 *  (If necessary, you may want to comment out or otherwise
 *  disable the troublesome calls.  You can knock them out all at
 *  once by #defining NOBADCALLS, but that will rwnie mask most of
 *  the warnings and errors that your compiler ought to report.
 *  If you're using a compiler which treats pointer mismatches
 *  as fatal errors, you can #define NOBADSYNTAX to shut of the
 *  uncast mismatches.)
 *
 *  Niektre wywoania funkcji w tym programie (opatrzone komentarzem 
 *  "nie powinno dziaa", a szczeglnie wywoania funkcji f3()) prawie 
 *  napewno spowoduj bdy magistrali albo naruszenia segmentacji. 
 *  Program przechwytuje te sygnay, wypisuje odpowienie komunikaty i 
 *  prbuje kontunuowa dziaanie, ale w pewnych okolicznociach, ktre 
 *  wynikaj z kwestii sprztowych, moe to spowodowa zaptlenie 
 *  programu. Nie uruchamiaj go, jeeli nie bdzie mona przerwa jego 
 *  dziaania klawiszami CTRL-C czy podobnymi. (Jeeli to konieczne, 
 *  moesz wykomentowa albo w inny sposb wyczy niebezpieczne 
 *  wywoania. Uywajc #define NOBADCALLS mona je wyczy wszystkie 
 *  na raz, ale w ten sposb usuniesz rwnie wikszo pozostaych 
 *  bdnych lub podejrzanych konstrukcji, ktre powinien zgosi 
 *  kompilator. Jeeli Twj kompilator traktuje niezgodno typw 
 *  wskanikw jako bd, moesz uy #define NOBADSYNTAX, aby je 
 *  wyczy.
 *
 *  The calls that work should all print lines of the form
 *  Wywoania funkcji, ktre dziaaj poprawnie, powinny wypisywa 
 *  wiersze w postaci:
 *
 *	x00	x01	x02	x03	x04
 *	x10	x11	x12	x13	x14
 *	x20	x21	x22	x23	x24
 *
 *  gdzie x to 0, 1, 2, 3 lub 4 w zalenoci od tego, ktra "tablica" 
 *  jest wypisywana.
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 *
 *  Steve Summit 5/7/93
 */

#include <stdio.h>
#include <stdlib.h>	/* uyj "extern char *malloc();" */
			/* jeeli nie posiadasz <stdlib.h> */
#include <signal.h>

#ifdef mac
#include <console.h>
#endif

#ifndef __STDC__
#define void int
#endif

#define NROWS	 3
#define NCOLUMNS 5

#define Arrayval(array, ncolumns, i, j) array[i * ncolumns + j]

#ifdef __STDC__

int main(int, char *[]);
void bombsaway(int);

void f(int array[][NCOLUMNS], int nrows, int ncolumns);
void f2(int *array, int nrows, int ncolumns);
void f3(int **array, int nrows, int ncolumns);

#endif

void bombsaway();

/* ARGSUSED */

int
main(argc, argv)
int argc;
char *argv[];
{
int nrows = NROWS;
int ncolumns = NCOLUMNS;
int array[NROWS][NCOLUMNS];
int **array1;
int **array2;
int *array3;
int (*array4)[NCOLUMNS];
int (*array5)[NROWS][NCOLUMNS];
int i, j;
int *ip;

#ifdef mac
argc = ccommand(&argv);
#endif

#ifdef SIGBUS
signal(SIGBUS, bombsaway);
#endif
#ifdef SIGSEGV
signal(SIGSEGV, bombsaway);
#endif

array1 = (int **)malloc(nrows * sizeof(int *));
for(i = 0; i < nrows; i++)
	array1[i] = (int *)malloc(ncolumns * sizeof(int));

array2 = (int **)malloc(nrows * sizeof(int *));
array2[0] = (int *)malloc(nrows * ncolumns * sizeof(int));
for(i = 1; i < nrows; i++)
	array2[i] = array2[0] + i * ncolumns;

array3 = (int *)malloc(nrows * ncolumns * sizeof(int));

array4 = (int (*)[NCOLUMNS])malloc(nrows * sizeof(*array4));

array5 = (int (*)[NROWS][NCOLUMNS])malloc(sizeof(*array5));

for(i = 0; i < nrows; i++)
	{
	for(j = 0; j < ncolumns; j++)
		{
		array[i][j] = 10 * i + j;
		array1[i][j] = 100 + 10 * i + j;
		array2[i][j] = 200 + 10 * i + j;
		Arrayval(array3, ncolumns, i, j) = 300 + 10 * i + j;
		array4[i][j] = 400 + 10 * i + j;
		(*array5)[i][j] = 500 + 10 * i + j;
		}
	}

printf("jako tablice:\n\n");

printf("tablica:\n");
f(array, NROWS, NCOLUMNS);

#ifndef NOBADCALLS

printf("\narray1 (nie powinno dziaa):\n");
f((int (*)[NCOLUMNS])array1, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
if(0) f(array1, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */

#endif

printf("\narray2:\n");
f((int (*)[NCOLUMNS])(*array2), nrows, ncolumns);	/* podejrzane rzutowanie */
#ifndef NOBADSYNTAX
if(0) f(*array2, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif

printf("\narray3:\n");
f((int (*)[NCOLUMNS])array3, nrows, ncolumns);	/* podejrzane rzutowanie */
#ifndef NOBADSYNTAX
if(0) f(array3, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif

printf("\narray4:\n");
f(array4, nrows, ncolumns);

printf("\narray5:\n");
f(*array5, nrows, ncolumns);

printf("\n\njako \"symulowane\" tablice:\n\n");

printf("array:\n");
f2(&array[0][0], NROWS, NCOLUMNS);

printf("\narray ponownie (rwnie powinno dziaa):\n");
f2(*array, NROWS, NCOLUMNS);

#ifndef NOBADCALLS

printf("\narray1 (nie powinno dziaa):\n");
f2((int *)array1, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
#ifndef NOBADSYNTAX
if(0) f2(array1, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
printf("\narray1 na inny sposb (rwnie nie powinno dziaa):\n");
f2(*array1, nrows, ncolumns);

#endif

printf("\narray2:\n");
f2(*array2, nrows, ncolumns);

printf("\narray3:\n");
f2(array3, nrows, ncolumns);

printf("\narray4:\n");
f2(*array4, nrows, ncolumns);
printf("\narray4 na inny sposb (rwnie powinno dziaa):\n");
f2((int *)array4, nrows, ncolumns);	/* podejrzane rzutowanie */
#ifndef NOBADSYNTAX
if(0) f2(array4, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif

printf("\narray5:\n");
f2(**array5, nrows, ncolumns);

printf("\n\njako wskaniki:\n\n");

#ifndef NOBADCALLS

printf("array (nie powinno dziaa):\n");
f3((int **)array, NROWS, NCOLUMNS);	/* cakowicie niepoprawne rzutowanie */
if(0) f3(array, NROWS, NCOLUMNS);	/* sprawdzenie, czy kompilator ostrzee */
printf("\narray na inny sposb (rwnie nie powinno dziaa):\n");
ip = &array[0][0];
f3(&ip, NROWS, NCOLUMNS);

#endif

printf("\narray1:\n");
f3(array1, nrows, ncolumns);

printf("\narray2:\n");
f3(array2, nrows, ncolumns);

#ifndef NOBADCALLS

printf("\narray3 (nie powinno dziaa):\n");
f3((int **)array3, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
#ifndef NOBADSYNTAX
if(0) f3(array3, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
printf("\narray3 na inny sposb (rwnie nie powinno dziaa):\n");
f3(&array3, nrows, ncolumns);

#ifndef mac
printf("\narray4 (nie powinno dziaa):\n");
f3((int **)array4, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
if(0) f3(array4, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
printf("\narray4 na inny sposb (rwnie nie powinno dziaa):\n");
f3((int **)&array4, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
#ifndef NOBADSYNTAX
if(0) f3(&array4, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
printf("\narray4 na jeszcze inny sposb (rwnie nie powinno dziaa):\n");
#ifndef NOBADSYNTAX
ip = array4;				/* ostrzeenie */
#endif
ip = (int *)array4;			/* cakowicie niepoprawne rzutowanie */
f3(&ip, nrows, ncolumns);
printf("\narray4 na ostatni sposb (na pewno nie powinno dziaa):\n");
#ifndef NOBADSYNTAX
ip = &array4;				/* ostrzeenie */
#endif
ip = (int *)&array4;			/* cakowicie niepoprawne rzutowanie */
f3(&ip, nrows, ncolumns);

#ifndef mac
printf("\narray5 (nie powinno dziaa):\n");
f3((int **)array5, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
#ifndef NOBADSYNTAX
if(0) f3(array5, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
#endif
printf("\narray5 na inny sposb (rwnie nie powinno dziaa):\n");
f3((int **)&array5, nrows, ncolumns);	/* cakowicie niepoprawne rzutowanie */
#ifndef NOBADSYNTAX
if(0) f3(&array5, nrows, ncolumns);	/* sprawdzenie, czy kompilator ostrzee */
#endif
printf("\narray5 na jeszcze inny sposb (rwnie nie powinno dziaa):\n");
#ifndef NOBADSYNTAX
ip = array5;				/* ostrzeenie */
#endif
ip = (int *)array5;			/* cakowicie niepoprawne rzutowanie */
f3(&ip, nrows, ncolumns);
printf("\narray5 na ostatni sposb (na pewno nie powinno dziaa):\n");
#ifndef NOBADSYNTAX
ip = &array5;				/* ostrzeenie */
#endif
ip = (int *)&array5;			/* cakowicie niepoprawne rzutowanie */
f3(&ip, nrows, ncolumns);

#endif

return 0;
}

void
f(array, nrows, ncolumns)
int array[][NCOLUMNS];
int nrows, ncolumns;
{
int i, j;

for(i = 0; i < nrows; i++)
	{
	for(j = 0; j < ncolumns; j++)
		{
		if(j != 0)
			printf("\t");
		printf("%d", array[i][j]);
		}

	printf("\n");
	}
}

void
f2(array, nrows, ncolumns)
int *array;
int nrows, ncolumns;
{
int i, j;

for(i = 0; i < nrows; i++)
	{
	for(j = 0; j < ncolumns; j++)
		{
		if(j != 0)
			printf("\t");
		printf("%d", Arrayval(array, ncolumns, i, j));
		}

	printf("\n");
	}
}

void
f3(array, nrows, ncolumns)
int **array;
int nrows, ncolumns;
{
int i, j;

for(i = 0; i < nrows; i++)
	{
	for(j = 0; j < ncolumns; j++)
		{
		if(j != 0)
			printf("\t");
		printf("%d", array[i][j]);
		}

	printf("\n");
	}
}

/* ARGSUSED */

void
bombsaway(sig)
int sig;
{
switch(sig)
	{
#ifdef SIGBUS
	case SIGBUS:
		printf("Bd magistrali\n");
		break;
#endif
#ifdef SIGSEGV
	case SIGSEGV:
		printf("Naruszenie segmentacji\n");
		break;
#endif
	default:
		printf("Sygna %d\n", sig);
		break;
	}

signal(sig, bombsaway);
}
